const YEAR=document.getElementById('year'); if(YEAR) YEAR.textContent=new Date().getFullYear();
let LANG='ro';
const I18N={
  ro:{products:"Produse",partners:"Parteneri",about:"Despre",contact:"Contact",heroTitle:"Echipamente PSI, PPE & soluții pentru riscuri Li‑ion",heroSub:"Distribuție, implementare, mentenanță — Safety New Expert.",cta:"Solicită ofertă",seeCatalog:"Vezi catalog",categories:"Categorii",search:"Caută produse…",price:"Preț",specs:"Specificații",noResults:"Niciun rezultat. Ajustează filtrele.",name:"Nume",email:"Email",message:"Mesaj",send:"Trimite"},
  en:{products:"Products",partners:"Partners",about:"About",contact:"Contact",heroTitle:"Fire Safety, PPE & Li‑ion risk solutions",heroSub:"Distribution, implementation & maintenance — Safety New Expert.",cta:"Request a quote",seeCatalog:"Browse catalog",categories:"Categories",search:"Search products…",price:"Price",specs:"Specifications",noResults:"No results. Adjust filters.",name:"Name",email:"Email",message:"Message",send:"Send"}
};
const CATEGORIES=["All/Toate","PSI (Fire Safety)","PPE","Li‑ion Solutions","Service & Verifications"];
let PRODUCTS=[
  {id:"psi-1",sku:"P6-ABC",cat:"PSI (Fire Safety)",name:{ro:"Stingător pulbere ABC 6kg",en:"ABC Powder Extinguisher 6kg"},short:{ro:"Universal pentru spații comerciale/rezidențiale.",en:"Universal for commercial/residential."},price:{ro:"la cerere",en:"on request"},img:"img/psi.jpg",tags:["ABC","6kg"]},
  {id:"li-1",sku:"Li-Case",cat:"Li‑ion Solutions",name:{ro:"Kit intervenție incendii Li‑ion",en:"Li‑ion fire response kit"},short:{ro:"Accesorii, protecție, izolare sursă.",en:"Accessories, protection, source isolation."},price:{ro:"la cerere",en:"on request"},img:"img/liion.jpg",tags:["Li‑ion"]},
  {id:"ppe-1",sku:"PW-01",cat:"PPE",name:{ro:"Selecție Portwest — PPE",en:"Portwest — PPE selection"},short:{ro:"Îmbrăcăminte, încălțăminte, accesorii.",en:"Workwear, footwear, accessories."},price:{ro:"la cerere",en:"on request"},img:"img/ppe.jpg",tags:["Portwest"]},
  {id:"ppe-2",sku:"DAL-01",cat:"PPE",name:{ro:"Selecție Dalgeco — PPE",en:"Dalgeco — PPE selection"},short:{ro:"Echipamente de protecție selectate.",en:"Curated protective equipment."},price:{ro:"la cerere",en:"on request"},img:"img/ppe.jpg",tags:["Dalgeco"]},
  {id:"srv-1",sku:"SRV",cat:"Service & Verifications",name:{ro:"Service PSI & verificări periodice",en:"Service & periodic inspections"},short:{ro:"Conform legislației în vigoare.",en:"Compliant with local regulations."},price:{ro:"la cerere",en:"on request"},img:"img/service.jpg",tags:["service"]}
];

// Tabs
document.querySelectorAll('.tab').forEach(t=>t.addEventListener('click',()=>{
  const tab=t.dataset.tab; document.querySelectorAll('.tab').forEach(x=>x.classList.remove('active')); t.classList.add('active');
  document.querySelectorAll('main .section').forEach(s=>s.classList.add('hidden')); document.getElementById(tab).classList.remove('hidden');
  if(tab==='products') location.hash='#'; else location.hash='#'+tab;
}));
document.querySelectorAll('.tabjump').forEach(b=>b.addEventListener('click',()=>document.querySelector('.tab[data-tab="products"]').click()));

// Lang
function setLang(l){ LANG=l; document.querySelectorAll('[data-i18n]').forEach(el=>{const k=el.dataset.i18n; if(I18N[l][k]) el.textContent=I18N[l][k];}); document.getElementById('searchInput').placeholder=I18N[l].search; renderProducts(); }
document.querySelectorAll('.lang').forEach(b=>b.addEventListener('click',()=>setLang(b.dataset.lang))); setLang('ro');

// Categories
const catBar=document.getElementById('catBar'); let activeCat="All/Toate";
function renderCategories(){ catBar.innerHTML=''; CATEGORIES.forEach(c=>{ const btn=document.createElement('button'); btn.className='pill'+(activeCat===c?' active':''); btn.textContent=c; btn.onclick=()=>{activeCat=c; renderCategories(); renderProducts();}; catBar.appendChild(btn); }); }

// Products
const grid=document.getElementById('productGrid'); const noResults=document.getElementById('noResults'); const qInput=document.getElementById('searchInput');
qInput.addEventListener('input', renderProducts);
function card(p){ return `<div class="card"><div class="small muted">${p.sku}</div><h3>${p.name[LANG]}</h3><img src="${p.img}" alt="${p.name[LANG]}"/><div class="small muted">${p.short[LANG]}</div><div class="small"><strong>${I18N[LANG].price}:</strong> ${p.price[LANG]}</div><div class="tags">${(p.tags||[]).slice(0,3).map(t=>`<span class='tag'>${t}</span>`).join('')}</div></div>`; }
function renderProducts(){
  const term=(qInput.value||'').toLowerCase().trim();
  const list=PRODUCTS.filter(p => (activeCat==="All/Toate" || p.cat===activeCat) && (term==='' || (`${p.name[LANG]} ${p.sku} ${p.short[LANG]} ${(p.tags||[]).join(' ')}`.toLowerCase().includes(term))));
  grid.innerHTML=list.map(card).join(''); noResults.classList.toggle('hidden', list.length>0);
}

// Contact form
document.addEventListener('DOMContentLoaded', () => {
  const form = document.querySelector('section#contact form.card'); if(!form) return;
  const inputs = form.querySelectorAll('input, textarea'); const btn=form.querySelector('button');
  btn.addEventListener('click', async () => {
    const payload={name:inputs[0].value.trim(),email:inputs[1].value.trim(),message:inputs[2].value.trim(),when:new Date().toISOString()};
    if(!payload.name||!payload.email||!payload.message){ alert(LANG==='ro'?'Completează toate câmpurile.':'Please fill all fields.'); return; }
    const cfg = (window.SNE_CONFIG && window.SNE_CONFIG.forms) || {};
    if(cfg.formspreeId){
      try{
        const res = await fetch('https://formspree.io/f/' + cfg.formspreeId, { method:'POST', headers:{'Content-Type':'application/json'}, body:JSON.stringify(payload) });
        if(res.ok){ alert(LANG==='ro'?'Mesaj trimis. Mulțumim!':'Message sent. Thank you!'); inputs.forEach(i=>i.value=''); return; }
      }catch(e){}
    }
    const emails=(window.SNE_CONFIG?.company?.emails||[]).join(',');
    const subject=encodeURIComponent((LANG==='ro'?'Mesaj nou — ':'New message — ')+payload.name);
    const body=encodeURIComponent((LANG==='ro'?'Nume: ':'Name: ')+payload.name+'\nEmail: '+payload.email+'\n\n'+(LANG==='ro'?'Mesaj:\n':'Message:\n')+payload.message+'\n\n'+payload.when);
    window.location.href='mailto:'+emails+'?subject='+subject+'&body='+body;
  });
});

renderCategories(); renderProducts();
